####################################################
### code chunk number : p_N_IG_mu_alpha_beta and pt
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
set.seed(1)
# mu = 0        ## hyperparameter
# alpha = 3     ## hyperparameter
# beta = 1      ## hyperparameter
mu = 0        ## hyperparameter
alpha = 3     ## hyperparameter
beta = 1      ## hyperparameter

x = seq(-10, 10, by = 0.1)
L_x = length(x)

Marginal_density = function(x){
res = gamma(alpha + 1/2) / (gamma(alpha) * sqrt(2 * pi * beta)) * (1 + (x - mu)^2 / (2 * beta))^(- alpha - 1/2)
}

p_N_IG_mu_alpha_beta = function(x, mu, alpha, beta){
mu <<- mu
alpha <<- alpha
beta <<- beta
	
L_x = length(x)
I_value = I_abs_error = numeric(L_x)
for (i in 1:L_x){
	I_i = integrate(f = Marginal_density, lower = - Inf, upper = x[i])
	I_value[i] = I_i$value
	I_abs_error[i] = I_i$abs.error
}

res = I_value
}

F1 = p_N_IG_mu_alpha_beta(x, mu, alpha, beta); F1
F2 = pt(q = (x - mu) / sqrt(beta / alpha), df = 2 * alpha); F2
F1 - F2

# x = rt(100, df = 3)

ks_test_1_m = ks.test(x, "p_N_IG_mu_alpha_beta", mu, alpha, beta)
cat("\n ks_test_1_m\n"); print(ks_test_1_m); cat("\n")

ks_test_2_m = ks.test((x - mu) / sqrt(beta / alpha), "pt", 2 * alpha)
cat("\n ks_test_2_m\n"); print(ks_test_2_m); cat("\n")


## plot F1 and F2
dev.new()
col = c("red", "blue")
lty = 1:2
xlim = range(x); xlim
ylim = range(F1, F2); ylim
plot(x, F1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = expression(F(x)))
lines(x, F1, lty = lty[1], col = col[1], lwd = 4)
lines(x, F2, lty = lty[2], col = col[2], lwd = 4)
# title(Title)
leg.txt = c("F1", "F2")
legend("topleft", legend = leg.txt, lty = lty, col = col, lwd = 2)
savePlot(filename = paste("figure/F1_F2", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/F1_F2", sep=""), type = c("jpg"))


####################################################
### code chunk number : Histogram: two curves
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## 
rt<-read.table("data/bodyfat.txt", head=TRUE)
class(rt)
dim(rt)

x = rt$Pct.BF
length(x)
range(x)

## 
## Histogram
## 
dev.new()
col = c("blue", "red")
lty = 1:2
hist(x, probability = TRUE,
    main = paste("Histogram of" , "x"), 
    xlab = "x", ylim = c(0, 0.06)) 
lines(density(x), lty = lty[1], col = col[1], lwd = 2)
x_norm = seq(min(x), max(x), length = 100)
y_norm = dnorm(x_norm, mean = mean(x), sd = sd(x))
lines(x_norm, y_norm, lty = lty[2], col = col[2], lwd = 2)
leg.txt = c("Density estimation","Normal approximation")
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/Histogram_x_2", type = c("pdf"))
savePlot(filename = "figure/Histogram_x_2", type = c("jpg"))

## Normality tests
shapiro.test(x)
ks.test(x, "pnorm", mean = mean(x), sd = sd(x))


####################################################
### code chunk number : A Real Data Example
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## The log-transformed data is normal.
AT = scan("assets_total.data")
x = log(AT)
x = x[!is.na(x)]; x
length(x)
range(x)

## Histogram
dev.new()
col = c("blue", "red")
lty = 1:2
hist(x, probability = TRUE,
    main = paste("Histogram of" , "x"), 
    xlab = "x", ylim = c(0, 0.4)) ## ylim = c(0, 7)
lines(density(x), lty = lty[1], col = col[1], lwd = 2)
x_norm = seq(min(x), max(x), length = 100)
y_norm = dnorm(x_norm, mean = mean(x), sd = sd(x))
lines(x_norm, y_norm, lty = lty[2], col = col[2], lwd = 2)
leg.txt = c("Density estimation","Normal approximation")
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/Histogram_x", type = c("pdf"))
savePlot(filename = "figure/Histogram_x", type = c("jpg"))

## Normality tests
shapiro.test(x)
ks.test(x, "pnorm", mean = mean(x), sd = sd(x))

m = 10

## Group and count
a = quantile(x, probs = seq(0, 1, length = m + 1)) ## cut-off points
a[1] = -Inf
a[m + 1] = Inf
a
nn = table(cut(x, br = a)); nn ## frequencies

## 
## When mu, alpha, and beta are unknown, and they are estimated by their moment estimators.
## 

## Compute theoretical probabilities
## Moment estimators
mu_1_alpha_1_beta_1 = Moment_estimators(x); mu_1_alpha_1_beta_1
mu_1 = mu_1_alpha_1_beta_1[1]; mu_1
alpha_1 = mu_1_alpha_1_beta_1[2]; alpha_1
beta_1 = mu_1_alpha_1_beta_1[3]; beta_1
p_moment = rep(0, m)
for (i in 1:(m - 1)){
	p_moment[i] = pt(q = (a[i + 1] - mu_1) / sqrt(beta_1 / alpha_1), df = 2 * alpha_1) - 
	              pt(q = (a[i] - mu_1)     / sqrt(beta_1 / alpha_1), df = 2 * alpha_1)
}
p_moment[m] = 1 - sum(p_moment)
p_moment
sum(p_moment)

## Test
df_3_moment = Pearson_chisquare_test(nn = nn, p = p_moment, r = 3); df_3_moment

## Compute_Estimators_PESLs
res_moment = Compute_Estimators_PESLs(alpha = alpha_1, beta = beta_1, x)
res_moment

## Compute the mean and variance of the assets total (AT) data
E_V_AT_moment = Compute_mean_variance_AT(mu_hat = mean(x), theta_hat = res_moment$delta_s)
E_V_AT_moment

## 
## When mu, alpha, and beta are unknown, and they are estimated by their MLEs.
## 

## Compute theoretical probabilities
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1, x = x)
mu_2_alpha_2_beta_2 = res_Newtons$root
mu_2 = mu_2_alpha_2_beta_2[1]; mu_2
alpha_2 = mu_2_alpha_2_beta_2[2]; alpha_2
beta_2 = mu_2_alpha_2_beta_2[3]; beta_2
p_MLE = rep(0, m)
for (i in 1:(m - 1)){
	p_MLE[i] = pt(q = (a[i + 1] - mu_2) / sqrt(beta_2 / alpha_2), df = 2 * alpha_2) - 
	           pt(q = (a[i] - mu_2)     / sqrt(beta_2 / alpha_2), df = 2 * alpha_2)
}
p_MLE[m] = 1 - sum(p_MLE)
p_MLE
sum(p_MLE)

## Test
df_3_MLE = Pearson_chisquare_test(nn = nn, p = p_MLE, r = 3); df_3_MLE

## Compute_Estimators_PESLs
res_MLE = Compute_Estimators_PESLs(alpha = alpha_2, beta = beta_2, x)
res_MLE

## Compute the mean and variance of the assets total (AT) data
E_V_AT_MLE = Compute_mean_variance_AT(mu_hat = mean(x), theta_hat = res_MLE$delta_s)
E_V_AT_MLE



####################################################
### code chunk number : Simulations: Marginal density, alpha changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                         ## hyperparameter
alpha = c(2.1, 2.5, 3, 6, 12)  ## hyperparameter
beta = 1                       ## hyperparameter

x = seq(-5, 5, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[1], beta); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[2], beta); 
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[3], beta);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[4], beta);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[5], beta);   

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 3)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 3)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 3)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 3)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 3)
# title(Title)
leg.txt = c(
expression(paste(alpha, " = 2.1", sep = "")),
expression(paste(alpha, " = 2.5", sep = "")),
expression(paste(alpha, " = 3", sep = "")),
expression(paste(alpha, " = 6", sep = "")),
expression(paste(alpha, " = 12", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/md_x_alpha_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/md_x_alpha_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, alpha changes, right tail
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                         ## hyperparameter
alpha = c(2.1, 2.5, 3, 6, 12)  ## hyperparameter
beta = 1                       ## hyperparameter

x = seq(3, 10, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[1], beta); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[2], beta); 
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[3], beta);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[4], beta);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[5], beta); 
md6 = dnorm(x) 

dev.new()
col = 1:6
lty = 1:6
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5, md6); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 3)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 3)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 3)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 3)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 3)
lines(x, md6,  lty = lty[6], col = col[6], lwd = 3)
# title(Title)
leg.txt = c(
expression(paste(alpha, " = 2.1", sep = "")),
expression(paste(alpha, " = 2.5", sep = "")),
expression(paste(alpha, " = 3", sep = "")),
expression(paste(alpha, " = 6", sep = "")),
expression(paste(alpha, " = 12", sep = "")),
expression(paste("N(0, 1)", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/md_x_alpha_changes_right_tail", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/md_x_alpha_changes_right_tail", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Ratio of marginal densities, alpha changes, right tail
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                         ## hyperparameter
alpha = c(2.1, 2.5, 3, 6, 12)  ## hyperparameter
beta = 1                       ## hyperparameter

x = seq(3, 5, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[1], beta); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[2], beta); 
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[3], beta);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[4], beta);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[5], beta); 
md6 = dnorm(x)

rmd1 = md1 / md6
rmd2 = md2 / md6
rmd3 = md3 / md6
rmd4 = md4 / md6
rmd5 = md5 / md6

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(rmd1, rmd2, rmd3, rmd4, rmd5); ylim
plot(x, rmd1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Ratio of marginal densities")
lines(x, rmd1,  lty = lty[1], col = col[1], lwd = 3)
lines(x, rmd2,  lty = lty[2], col = col[2], lwd = 3)
lines(x, rmd3,  lty = lty[3], col = col[3], lwd = 3)
lines(x, rmd4,  lty = lty[4], col = col[4], lwd = 3)
lines(x, rmd5,  lty = lty[5], col = col[5], lwd = 3)
# title(Title)
leg.txt = c(
expression(paste(alpha, " = 2.1", sep = "")),
expression(paste(alpha, " = 2.5", sep = "")),
expression(paste(alpha, " = 3", sep = "")),
expression(paste(alpha, " = 6", sep = "")),
expression(paste(alpha, " = 12", sep = ""))
)
legend("topleft", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/rmd_x_alpha_changes_right_tail", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/rmd_x_alpha_changes_right_tail", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Ratio of marginal densities, alpha = c(6, 12), right tail
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                         ## hyperparameter
alpha = c(2.1, 2.5, 3, 6, 12)  ## hyperparameter
beta = 1                       ## hyperparameter

x = seq(3, 10, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[1], beta); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[2], beta); 
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[3], beta);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[4], beta);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha = alpha[5], beta); 
md6 = dnorm(x)

rmd1 = md1 / md6
rmd2 = md2 / md6
rmd3 = md3 / md6
rmd4 = md4 / md6
rmd5 = md5 / md6

## 
## alpha = 6
## 
dev.new()
col = 4
lty = 4
xlim = range(x); xlim
ylim = range(rmd4); ylim
plot(x, rmd4, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Ratio of marginal densities")
lines(x, rmd4,  lty = lty, col = col, lwd = 3)
leg.txt = c(
expression(paste(alpha, " = 6", sep = ""))
)
legend("topleft", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/rmd_x_alpha_6_right_tail", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/rmd_x_alpha_6_right_tail", sep=""), type = c("jpg"))

## 
## alpha = 12
## 
dev.new()
col = 5
lty = 5
xlim = range(x); xlim
ylim = range(rmd5); ylim
plot(x, rmd5, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Ratio of marginal densities")
lines(x, rmd5,  lty = lty, col = col, lwd = 3)
leg.txt = c(
expression(paste(alpha, " = 12", sep = ""))
)
legend("topleft", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/rmd_x_alpha_12_right_tail", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/rmd_x_alpha_12_right_tail", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, beta changes
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                       ## hyperparameter
alpha = 3                    ## hyperparameter
beta = c(0.25, 0.5, 1, 2, 4) ## hyperparameter

x = seq(-5, 5, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[1]); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[2]);  
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[3]);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[4]);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[5]);   

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 3)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 3)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 3)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 3)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 3)
# title(Title)
leg.txt = c(
expression(paste(beta, " = 0.25", sep = "")),
expression(paste(beta, " = 0.5", sep = "")),
expression(paste(beta, " = 1", sep = "")),
expression(paste(beta, " = 2", sep = "")),
expression(paste(beta, " = 4", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/md_x_beta_changes", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/md_x_beta_changes", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Marginal density, beta changes, right tail
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                       ## hyperparameter
alpha = 3                    ## hyperparameter
beta = c(0.25, 0.5, 1, 2, 4) ## hyperparameter

x = seq(3, 10, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[1]); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[2]);  
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[3]);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[4]);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[5]);  
md6 = dnorm(x) 

dev.new()
col = 1:6
lty = 1:6
xlim = range(x); xlim
ylim = range(md1, md2, md3, md4, md5, md6); ylim
plot(x, md1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Marginal density")
lines(x, md1,  lty = lty[1], col = col[1], lwd = 3)
lines(x, md2,  lty = lty[2], col = col[2], lwd = 3)
lines(x, md3,  lty = lty[3], col = col[3], lwd = 3)
lines(x, md4,  lty = lty[4], col = col[4], lwd = 3)
lines(x, md5,  lty = lty[5], col = col[5], lwd = 3)
lines(x, md6,  lty = lty[6], col = col[6], lwd = 3)
# title(Title)
leg.txt = c(
expression(paste(beta, " = 0.25", sep = "")),
expression(paste(beta, " = 0.5", sep = "")),
expression(paste(beta, " = 1", sep = "")),
expression(paste(beta, " = 2", sep = "")),
expression(paste(beta, " = 4", sep = "")),
expression(paste("N(0, 1)", sep = ""))
)
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/md_x_beta_changes_right_tail", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/md_x_beta_changes_right_tail", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Ratio of marginal densities, beta changes, right tail
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                       ## hyperparameter
alpha = 3                    ## hyperparameter
beta = c(0.25, 0.5, 1, 2, 4) ## hyperparameter

x = seq(3, 5, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[1]); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[2]);  
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[3]);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[4]);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[5]); 
md6 = dnorm(x)

rmd1 = md1 / md6
rmd2 = md2 / md6
rmd3 = md3 / md6
rmd4 = md4 / md6
rmd5 = md5 / md6

dev.new()
col = 1:5
lty = 1:5
xlim = range(x); xlim
ylim = range(rmd1, rmd2, rmd3, rmd4, rmd5); ylim
plot(x, rmd1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Ratio of marginal densities")
lines(x, rmd1,  lty = lty[1], col = col[1], lwd = 3)
lines(x, rmd2,  lty = lty[2], col = col[2], lwd = 3)
lines(x, rmd3,  lty = lty[3], col = col[3], lwd = 3)
lines(x, rmd4,  lty = lty[4], col = col[4], lwd = 3)
lines(x, rmd5,  lty = lty[5], col = col[5], lwd = 3)
# title(Title)
leg.txt = c(
expression(paste(beta, " = 0.25", sep = "")),
expression(paste(beta, " = 0.5", sep = "")),
expression(paste(beta, " = 1", sep = "")),
expression(paste(beta, " = 2", sep = "")),
expression(paste(beta, " = 4", sep = ""))
)
legend("topleft", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/rmd_x_beta_changes_right_tail", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/rmd_x_beta_changes_right_tail", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Ratio of marginal densities, beta = c(0.25, 0.5), right tail
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0                       ## hyperparameter
alpha = 3                    ## hyperparameter
beta = c(0.25, 0.5, 1, 2, 4) ## hyperparameter

x = seq(3, 6, by = 0.01)
md1 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[1]); 
md2 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[2]);  
md3 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[3]);  
md4 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[4]);  
md5 = Marginal_density_mu_alpha_beta(x, mu, alpha, beta = beta[5]); 
md6 = dnorm(x)

rmd1 = md1 / md6
rmd2 = md2 / md6
rmd3 = md3 / md6
rmd4 = md4 / md6
rmd5 = md5 / md6

## 
## beta = 0.25
## 
dev.new()
col = 1
lty = 1
xlim = range(x); xlim
ylim = range(rmd1); ylim
plot(x, rmd1, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Ratio of marginal densities")
lines(x, rmd1,  lty = lty, col = col, lwd = 3)
leg.txt = c(
expression(paste(beta, " = 0.25", sep = ""))
)
legend("topleft", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/rmd_x_beta_0p25_right_tail", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/rmd_x_beta_0p25_right_tail", sep=""), type = c("jpg"))

## 
## beta = 0.5
## 
dev.new()
col = 2
lty = 2
xlim = range(x); xlim
ylim = range(rmd2); ylim
plot(x, rmd2, type = "n", xlim = xlim, ylim = ylim, xlab = expression(x), ylab = "Ratio of marginal densities")
lines(x, rmd2,  lty = lty, col = col, lwd = 3)
leg.txt = c(
expression(paste(beta, " = 0.5", sep = ""))
)
legend("topleft", legend = leg.txt, lty = lty, col = col)
savePlot(filename = paste("figure/rmd_x_beta_0p5_right_tail", sep=""), type = c("pdf"))
savePlot(filename = paste("figure/rmd_x_beta_0p5_right_tail", sep=""), type = c("jpg"))


####################################################
### code chunk number : Simulations: Right tail probability
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

TP_Z_3 = 1 - pnorm(3); TP_Z_3

beta = c(0.25, 0.5, 1, 2, 4)
TP_X_3_beta = 1 - pt(3*sqrt(3)/sqrt(beta), df = 6); TP_X_3_beta

beta = 10^(1:5)
TP_X_3_beta = 1 - pt(3*sqrt(3)/sqrt(beta), df = 6); TP_X_3_beta

alpha = c(2.1, 2.5, 3, 6, 12)
TP_X_3_alpha = 1 - pt(3*sqrt(alpha), df = 2*alpha); TP_X_3_alpha
1 - pt(3*sqrt(2), df = 2*2)

v = c(1, 2, 5, 10, 100)
TP_X_3_v = 1 - pt(3, df = v); TP_X_3_v


####################################################
### code chunk number : A Real Data Example
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

data = read.csv("2013_data.csv"); data

## The data is not normal.
x_5 = data[, 5]
write(x_5, file = "assets_total.data")
x_5 = x_5[!is.na(x_5)]; x_5
length(x_5)
range(x_5)
## Histogram
col = c("blue", "red")
lty = 1:2
hist(x_5, probability = TRUE,
    main = paste("Histogram of" , "x_5"), 
    xlab = "x_5") ## ylim = c(0, 7)
lines(density(x_5), lty = lty[1], col = col[1], lwd = 2)
x_norm = seq(min(x_5), max(x_5), length = 100)
y_norm = dnorm(x_norm, mean = mean(x_5), sd = sd(x_5))
lines(x_norm, y_norm, lty = lty[2], col = col[2], lwd = 2)
leg.txt = c("Density estimation", "Normal approximation")
legend("topright", legend = leg.txt, lty = lty, col = col)

shapiro.test(x_5)
ks.test(x_5, "pnorm", mean = mean(x_5), sd = sd(x_5))

## The log-transformed data is normal.
x = log(data[, 5]); x ## 5-11, x = data[, 5]; x = log(data[, 5])
x = x[!is.na(x)]; x
length(x)
## log(data[, 5]): OK
## log(data[, 6]): not OK
## log(data[, 7]): not OK
## log(data[, 8]): not OK
## log(data[, 9]): not OK (moment not OK, MLE OK)
## log(data[, 10]): not OK (moment not OK, MLE OK)
## log(data[, 11]): not OK
range(x)

## Histogram
dev.new()
col = c("blue", "red")
lty = 1:2
hist(x, probability = TRUE,
    main = paste("Histogram of" , "x"), 
    xlab = "x", ylim = c(0, 0.4)) ## ylim = c(0, 7)
lines(density(x), lty = lty[1], col = col[1], lwd = 2)
x_norm = seq(min(x), max(x), length = 100)
y_norm = dnorm(x_norm, mean = mean(x), sd = sd(x))
lines(x_norm, y_norm, lty = lty[2], col = col[2], lwd = 2)
leg.txt = c("Density estimation","Normal approximation")
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/Histogram_x", type = c("pdf"))
savePlot(filename = "figure/Histogram_x", type = c("jpg"))

## Normality tests
shapiro.test(x)
ks.test(x, "pnorm", mean = mean(x), sd = sd(x))

m = 10

## Group and count
a = quantile(x, probs = seq(0, 1, length = m + 1)) ## cut-off points
a[1] = -Inf
a[m + 1] = Inf
a
nn = table(cut(x, br = a)); nn ## frequencies

## 
## When mu, alpha, and beta are unknown, and they are estimated by their moment estimators.
## 

## Compute theoretical probabilities
## Moment estimators
mu_1_alpha_1_beta_1 = Moment_estimators(x); mu_1_alpha_1_beta_1
mu_1 = mu_1_alpha_1_beta_1[1]; mu_1
alpha_1 = mu_1_alpha_1_beta_1[2]; alpha_1
beta_1 = mu_1_alpha_1_beta_1[3]; beta_1
p_moment = rep(0, m)
for (i in 1:(m - 1)){
	p_moment[i] = pt(q = (a[i + 1] - mu_1) / sqrt(beta_1 / alpha_1), df = 2 * alpha_1) - 
	              pt(q = (a[i] - mu_1)     / sqrt(beta_1 / alpha_1), df = 2 * alpha_1)
}
p_moment[m] = 1 - sum(p_moment)
p_moment
sum(p_moment)

## Test
df_3_moment = Pearson_chisquare_test(nn = nn, p = p_moment, r = 3); df_3_moment

## Compute_Estimators_PESLs
res_moment = Compute_Estimators_PESLs(alpha = alpha_1, beta = beta_1, x)
res_moment

## Compute the mean and variance of the assets total (AT) data
E_V_AT_moment = Compute_mean_variance_AT(mu_hat = mean(x), theta_hat = res_moment$delta_s)
E_V_AT_moment

## 
## When mu, alpha, and beta are unknown, and they are estimated by their MLEs.
## 

## Compute theoretical probabilities
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1, x = x)
mu_2_alpha_2_beta_2 = res_Newtons$root
mu_2 = mu_2_alpha_2_beta_2[1]; mu_2
alpha_2 = mu_2_alpha_2_beta_2[2]; alpha_2
beta_2 = mu_2_alpha_2_beta_2[3]; beta_2
p_MLE = rep(0, m)
for (i in 1:(m - 1)){
	p_MLE[i] = pt(q = (a[i + 1] - mu_2) / sqrt(beta_2 / alpha_2), df = 2 * alpha_2) - 
	           pt(q = (a[i] - mu_2)     / sqrt(beta_2 / alpha_2), df = 2 * alpha_2)
}
p_MLE[m] = 1 - sum(p_MLE)
p_MLE
sum(p_MLE)

## Test
df_3_MLE = Pearson_chisquare_test(nn = nn, p = p_MLE, r = 3); df_3_MLE

## Compute_Estimators_PESLs
res_MLE = Compute_Estimators_PESLs(alpha = alpha_2, beta = beta_2, x)
res_MLE

## Compute the mean and variance of the assets total (AT) data
E_V_AT_MLE = Compute_mean_variance_AT(mu_hat = mean(x), theta_hat = res_MLE$delta_s)
E_V_AT_MLE


####################################################
### code chunk number : monthly, simple return
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(quantmod)
# SSE = getSymbols("000001.SS", auto.assign=FALSE, from = "2007-01-08", to = "2018-05-26")
SSE = getSymbols("000001.SS", auto.assign=FALSE, from = "2007-01-08", to = "2017-01-13")
head(SSE)

SSE_close = SSE[, 4]
N = length(SSE_close); N
N_m = floor(N / 20); N_m
SSE_close_m = SSE[20*(1:N_m), 4]
plot(SSE_close_m)

## simple return
SSE_return_m = SSE_close_m[2:N_m]
SSE_return_m[, 1] = (as.vector(SSE_close_m[2:N_m]) - as.vector(SSE_close_m[1:(N_m-1)])) / as.vector(SSE_close_m[1:(N_m-1)])
dimnames(SSE_return_m)[[2]] = "Return"
SSE_return_m

## p-value = 0.03536
dev.new()
res_return_m = shapiro.test(as.vector(SSE_return_m)); res_return_m
plot(SSE_return_m)

## Histogram_SSE_monthly_simple_return
Return_m = as.vector(SSE_return_m)
col = c("blue", "red")
lty = 1:2
hist(Return_m, probability = TRUE,
    main = paste("Histogram of" , "SSE monthly simple return"), 
    xlab = "SSE monthly simple return", ylim = c(0, 7))
lines(density(Return_m), lty = lty[1], col = col[1], lwd = 2)
x = seq(-0.3, 0.3, by = 0.001)
y = dnorm(x, mean(Return_m), sd(Return_m))
lines(x, y,              lty = lty[2], col = col[2], lwd = 2)
leg.txt = c( "Density estimation","Normal approximation")
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/Histogram_SSE_monthly_simple_return", type = c("pdf"))
savePlot(filename = "figure/Histogram_SSE_monthly_simple_return", type = c("jpg"))

#### 
#### Goodness-of-fit
#### 

## Group and count
m = 10 ## number of groups
x = Return_m
a = quantile(x, probs = seq(0, 1, length = m + 1)) ## cut-off points
a[1] = -Inf
a[m + 1] = Inf
a
nn = table(cut(x, br = a)); nn ## frequencies

## 
## When mu, alpha, and beta are unknown, and they are estimated by their moment estimators.
## 

## Compute theoretical probabilities
## Moment estimators
mu_1_alpha_1_beta_1 = Moment_estimators(x); mu_1_alpha_1_beta_1
mu_1 = mu_1_alpha_1_beta_1[1]; mu_1
alpha_1 = mu_1_alpha_1_beta_1[2]; alpha_1
beta_1 = mu_1_alpha_1_beta_1[3]; beta_1
p_moment = rep(0, m)
for (i in 1:(m - 1)){
	p_moment[i] = pt(q = (a[i + 1] - mu_1) / sqrt(beta_1 / alpha_1), df = 2 * alpha_1) - 
	              pt(q = (a[i] - mu_1)     / sqrt(beta_1 / alpha_1), df = 2 * alpha_1)
}
p_moment[m] = 1 - sum(p_moment)
p_moment
sum(p_moment)

## Test
df_3_moment = Pearson_chisquare_test(nn = nn, p = p_moment, r = 3); df_3_moment

## 
## When mu, alpha, and beta are unknown, and they are estimated by their MLEs.
## 

## Compute theoretical probabilities
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1, x = x)
mu_2_alpha_2_beta_2 = res_Newtons$root
mu_2 = mu_2_alpha_2_beta_2[1]; mu_2
alpha_2 = mu_2_alpha_2_beta_2[2]; alpha_2
beta_2 = mu_2_alpha_2_beta_2[3]; beta_2
p_MLE = rep(0, m)
for (i in 1:(m - 1)){
	p_MLE[i] = pt(q = (a[i + 1] - mu_2) / sqrt(beta_2 / alpha_2), df = 2 * alpha_2) - 
	           pt(q = (a[i] - mu_2)     / sqrt(beta_2 / alpha_2), df = 2 * alpha_2)
}
p_MLE[m] = 1 - sum(p_MLE)
p_MLE
sum(p_MLE)

## Test
df_3_MLE = Pearson_chisquare_test(nn = nn, p = p_MLE, r = 3); df_3_MLE

#### 
#### Bootstrap
#### 

# B = 100
# n = length(x)
# X = matrix(0, nrow = n, ncol = B)
# for (j in 1:B){
	# X[, j] = sample(x, replace = TRUE)
# }
# x_B = as.vector(X)
# length(x_B)

set.seed(1) 
x_B = sample(x, size = 1e4, replace = TRUE)
length(x_B)

## Histogram_x_B
dev.new()
col = c("blue", "red")
lty = 1:2
hist(x_B, probability = TRUE,
    main = paste("Histogram of" , "x_B"), 
    xlab = "x_B", ylim = c(0, 7))
lines(density(x_B), lty = lty[1], col = col[1], lwd = 2)
x = seq(-0.3, 0.3, by = 0.001)
y = dnorm(x, mean(x_B), sd(x_B))
lines(x, y, lty = lty[2], col = col[2], lwd = 2)
leg.txt = c("Density estimation","Normal approximation")
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/Histogram_x_B", type = c("pdf"))
savePlot(filename = "figure/Histogram_x_B", type = c("jpg"))


## Group and count
m = 10 ## number of groups
a_B = quantile(x_B, probs = seq(0, 1, length = m + 1)) ## cut-off points
a_B[1] = -Inf
a_B[m + 1] = Inf
a_B
nn_B = table(cut(x_B, br = a_B)); nn_B ## frequencies

## 
## When mu, alpha, and beta are unknown, and they are estimated by their moment estimators.
## 

## Compute theoretical probabilities
## Moment estimators
mu_1_alpha_1_beta_1_B = Moment_estimators(x_B); mu_1_alpha_1_beta_1_B
mu_1_B = mu_1_alpha_1_beta_1_B[1]; mu_1_B
alpha_1_B = mu_1_alpha_1_beta_1_B[2]; alpha_1_B
beta_1_B = mu_1_alpha_1_beta_1_B[3]; beta_1_B
p_moment_B = rep(0, m)
for (i in 1:(m - 1)){
	p_moment_B[i] = pt(q = (a_B[i + 1] - mu_1_B) / sqrt(beta_1_B / alpha_1_B), df = 2 * alpha_1_B) - 
	                pt(q = (a_B[i] - mu_1_B)     / sqrt(beta_1_B / alpha_1_B), df = 2 * alpha_1_B)
}
p_moment_B[m] = 1 - sum(p_moment_B)
p_moment_B
sum(p_moment_B)

## Test
df_3_moment_B = Pearson_chisquare_test(nn = nn_B, p = p_moment_B, r = 3); df_3_moment_B

## 
## When mu, alpha, and beta are unknown, and they are estimated by their MLEs.
## 

## Compute theoretical probabilities
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons_B = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1_B, x = x_B)
mu_2_alpha_2_beta_2_B = res_Newtons_B$root
mu_2_B = mu_2_alpha_2_beta_2_B[1]; mu_2_B
alpha_2_B = mu_2_alpha_2_beta_2_B[2]; alpha_2_B
beta_2_B = mu_2_alpha_2_beta_2_B[3]; beta_2_B
p_MLE_B = rep(0, m)
for (i in 1:(m - 1)){
	p_MLE_B[i] = pt(q = (a_B[i + 1] - mu_2_B) / sqrt(beta_2_B / alpha_2_B), df = 2 * alpha_2_B) - 
	             pt(q = (a_B[i] - mu_2_B)     / sqrt(beta_2_B / alpha_2_B), df = 2 * alpha_2_B)
}
p_MLE_B[m] = 1 - sum(p_MLE_B)
p_MLE_B
sum(p_MLE_B)

## Test
df_3_MLE_B = Pearson_chisquare_test(nn = nn_B, p = p_MLE_B, r = 3); df_3_MLE_B


####################################################
### code chunk number : daily, simple return
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")
library(quantmod)
# SSE = getSymbols("000001.SS", auto.assign=FALSE, from = "2007-01-08", to = "2018-05-26")
SSE = getSymbols("000001.SS", auto.assign=FALSE, from = "2007-01-08", to = "2017-01-13")
head(SSE)

SSE_close = SSE[, 4]
N = length(SSE_close); N
SSE_close = na.omit(SSE_close)
N = length(SSE_close); N
plot(SSE_close)

## simple return
SSE_return_daily = SSE_close[2:N]
SSE_return_daily[, 1] = (as.vector(SSE_close[2:N]) - as.vector(SSE_close[1:(N-1)])) / as.vector(SSE_close[1:(N-1)])
dimnames(SSE_return_daily)[[2]] = "Return"

## p-value = 
dev.new()
res_return_m = shapiro.test(as.vector(SSE_return_daily)); res_return_m
plot(SSE_return_daily)

## Histogram_SSE_daily_simple_return
Return_daily = as.vector(SSE_return_daily)
col = c("blue", "red")
lty = 1:2
hist(Return_daily, probability = TRUE,
    main = paste("Histogram of" , "SSE daily simple return"), 
    xlab = "SSE daily simple return") ## ylim = c(0, 7)
lines(density(Return_daily), lty = lty[1], col = col[1], lwd = 2)
x = seq(-0.3, 0.3, by = 0.001)
y = dnorm(x, mean(Return_daily), sd(Return_daily))
lines(x, y, lty = lty[2], col = col[2], lwd = 2)
leg.txt = c("Density estimation","Normal approximation")
legend("topright", legend = leg.txt, lty = lty, col = col)
savePlot(filename = "figure/Histogram_SSE_daily_simple_return", type = c("pdf"))
savePlot(filename = "figure/Histogram_SSE_daily_simple_return", type = c("jpg"))

#### 
#### Goodness-of-fit
#### 

## Group and count
m = 10 ## number of groups
x = Return_daily
a = quantile(x, probs = seq(0, 1, length = m + 1)) ## cut-off points
a[1] = -Inf
a[m + 1] = Inf
a
nn = table(cut(x, br = a)); nn ## frequencies

## 
## When mu, alpha, and beta are unknown, and they are estimated by their moment estimators.
## 

## Compute theoretical probabilities
## Moment estimators
mu_1_alpha_1_beta_1 = Moment_estimators(x); mu_1_alpha_1_beta_1
mu_1 = mu_1_alpha_1_beta_1[1]; mu_1
alpha_1 = mu_1_alpha_1_beta_1[2]; alpha_1
beta_1 = mu_1_alpha_1_beta_1[3]; beta_1
p_moment = rep(0, m)
for (i in 1:(m - 1)){
	p_moment[i] = pt(q = (a[i + 1] - mu_1) / sqrt(beta_1 / alpha_1), df = 2 * alpha_1) - 
	              pt(q = (a[i] - mu_1)     / sqrt(beta_1 / alpha_1), df = 2 * alpha_1)
}
p_moment[m] = 1 - sum(p_moment)
p_moment
sum(p_moment)

## Test
df_3_moment = Pearson_chisquare_test(nn = nn, p = p_moment, r = 3); df_3_moment

## 
## When mu, alpha, and beta are unknown, and they are estimated by their MLEs.
## 

## Compute theoretical probabilities
## MLE
## The MLE is very sensitive to the initial guess. 
## The moment estimator is usually a good initial guess.
res_Newtons = Newtons(fun = moment_fun, p = mu_1_alpha_1_beta_1, x = x)
mu_2_alpha_2_beta_2 = res_Newtons$root
mu_2 = mu_2_alpha_2_beta_2[1]; mu_2
alpha_2 = mu_2_alpha_2_beta_2[2]; alpha_2
beta_2 = mu_2_alpha_2_beta_2[3]; beta_2
p_MLE = rep(0, m)
for (i in 1:(m - 1)){
	p_MLE[i] = pt(q = (a[i + 1] - mu_2) / sqrt(beta_2 / alpha_2), df = 2 * alpha_2) - 
	           pt(q = (a[i] - mu_2)     / sqrt(beta_2 / alpha_2), df = 2 * alpha_2)
}
p_MLE[m] = 1 - sum(p_MLE)
p_MLE
sum(p_MLE)

## Test
df_3_MLE = Pearson_chisquare_test(nn = nn, p = p_MLE, r = 3); df_3_MLE


####################################################
### code chunk number : Simulations: Moment estimators, mu_1_alpha_1_beta_1_max
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0               ## hyperparameter
alpha = 3            ## hyperparameter
beta = 1             ## hyperparameter
N = 10^(1:5); N      ## sample size
L_N = length(N); L_N ## the length of N
M = 100              ## number of simulations, to calculate the probability

set.seed(1) 
n = N[L_N]
x = matrix(0, nrow = M, ncol = n)
for (m in 1:M){
	theta_m = 1 / rgamma(n = n, shape = alpha, scale = beta)
	x[m, ] = rnorm(n = n, mean = mu, sd = sqrt(theta_m))
}

## Histogram
hist(x[1, ], probability = TRUE,
    main = paste("Histogram of" , "x[1, ]"), 
    xlab = "x")
lines(density(x[1, ]), col = "blue")

F1 = matrix(0, nrow = L_N, ncol = 3)
colnames(F1) = c("mu_1", "alpha_1", "beta_1")
mu_1 = alpha_1 = beta_1 = matrix(0, nrow = L_N, ncol = M)
for (j in 1:L_N){
	n = N[j]
	mu_1_alpha_1_beta_1 = matrix(0, nrow = M, ncol = 3)
	for (m in 1:M){
		x_j_m = x[m, 1:n]
		mu_1_alpha_1_beta_1[m, ] = Moment_estimators(x_j_m)
	}
	mu_1[j, ]    = mu_1_alpha_1_beta_1[, 1]
	alpha_1[j, ] = mu_1_alpha_1_beta_1[, 2]
	beta_1[j, ]  = mu_1_alpha_1_beta_1[, 3]
}
Abs_mu_1    = abs(mu_1 - matrix(mu, nrow = L_N, ncol = M)); ## round(Abs_mu_1, 3)
Abs_alpha_1 = abs(alpha_1 - matrix(alpha, nrow = L_N, ncol = M)); ## round(Abs_alpha_1, 3)
Abs_beta_1  = abs(beta_1 - matrix(beta, nrow = L_N, ncol = M)); ## round(Abs_beta_1, 3)

## epsilon = 1, 0.5, 0.1
epsilon = 1
F1[, 1] = apply((Abs_mu_1    >= epsilon), 1, mean)
F1[, 2] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 3] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)

epsilon = 0.5
F1[, 1] = apply((Abs_mu_1    >= epsilon), 1, mean)
F1[, 2] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 3] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)

epsilon = 0.1
F1[, 1] = apply((Abs_mu_1    >= epsilon), 1, mean)
F1[, 2] = apply((Abs_alpha_1 >= epsilon), 1, mean)
F1[, 3] = apply((Abs_beta_1  >= epsilon), 1, mean)
round(F1, 3)


####################################################
### code chunk number : Simulations: Moment estimators, mu_1_nu_1_sigma_1_max
####################################################
## 
## 
## 
rm(list=ls(all=TRUE))
source("subfunctions.R")

## initialization
mu = 0               ## hyperparameter
nu = 5              ## hyperparameter
sigma = 0.5          ## hyperparameter
N = 10^(1:5); N      ## sample size
L_N = length(N); L_N ## number of simulations

set.seed(4) ## 
x = theta = rep(0, N[L_N])
for (i in 1:N[L_N]){
	theta[i] = 1 / rgamma(n = 1, shape = nu / 2, scale = nu * sigma^2 / 2)
	x[i] = rnorm(n = 1, mean = mu, sd = sqrt(theta[i]))
}

data_outline(x)

## Histogram
hist(x, probability = TRUE,
    main = paste("Histogram of" , "x"), 
    xlab = "x")
lines(density(x), col = "blue")

mu_1_nu_1_sigma_1 = matrix(0, nrow = L_N, ncol = 3)
colnames(mu_1_nu_1_sigma_1) = c("mu_1", "nu_1", "sigma_1")
for (j in 1:L_N){
	n = N[j]
	x_j = x[1:n]
	
	#### Moment estimators
	mu_1_alpha_1_beta_1 = Moment_estimators(x_j)
	mu_1    = mu_1_alpha_1_beta_1[1]
	alpha_1 = mu_1_alpha_1_beta_1[2]
	beta_1  = mu_1_alpha_1_beta_1[3]
	
	nu_1 = 2 * alpha_1
	sigma_1 = sqrt(beta_1 / alpha_1)
	mu_1_nu_1_sigma_1[j, ] = c(mu_1, nu_1, sigma_1)
}
mu_1_nu_1_sigma_1

Abs_error_mu_1_nu_1_sigma_1_max = abs(mu_1_nu_1_sigma_1 - cbind(rep(mu, L_N), rep(nu, L_N), rep(sigma, L_N)))
round(Abs_error_mu_1_nu_1_sigma_1_max, 3)

A = matrix(0, nrow = L_N, ncol = 6)
A[, 1:3] = round(mu_1_nu_1_sigma_1, 3)
A[, 4:6] = round(Abs_error_mu_1_nu_1_sigma_1_max, 3)
A
A = format(A, nsmall = 3); A
Generate_Matrix_Latex(A)

## plot Abs_error_mu_1_nu_1_sigma_1_max
dev.new()
col = c("red", "blue", "black")
lty = 1:3
xlim = range(N)
ylim = c(0, 1)
plot(N, Abs_error_mu_1_nu_1_sigma_1_max[, 1], type = "n", log = "x", xlim = xlim, ylim = ylim, xlab = expression(n), ylab = "")
lines(N, Abs_error_mu_1_nu_1_sigma_1_max[, 1], lty = lty[1], col = col[1], lwd = 4)
lines(N, Abs_error_mu_1_nu_1_sigma_1_max[, 2], lty = lty[2], col = col[2], lwd = 4)
lines(N, Abs_error_mu_1_nu_1_sigma_1_max[, 3], lty = lty[3], col = col[3], lwd = 4)
leg.txt = c(
expression(group("|", mu[1](n) - mu, "|")),
expression(group("|", nu[1](n) - nu, "|")),
expression(group("|", sigma[1](n) - sigma, "|"))
)
legend("topright", legend = leg.txt, lty = lty, col = col, lwd = 2)	
savePlot(filename = paste("figure/Abs_error_mu_1_nu_1_sigma_1_max", sep=""), type = c("pdf"))


